VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CCGI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'The raw query string recieved by the CGI application.
Private m_sQueryString As String

'Dictionary containing all the Name/Value pairs in the query string.
Private m_dicParams As Scripting.Dictionary

'Dictionary Containing all the environmental variables
Private m_dicEnvVars As Scripting.Dictionary

'Standard I/O object
Private m_StdIo As CStdIO

'CStdIO Errors.
Public Enum enCGI_ERRORCODES
    cgiQUERY_STRING_EMPTY = 9020  'No data in query string
    cgiQUERY_STRING_PARSE         'Could not parse the query string. Check format.
    cgiINVALID_REQUEST_METHOD     'Invalid Request Method.
End Enum

'CGI Environmental Variables.  These also have corresponding strings
'in the string table resource.
Public Enum enCGI_ENVIRONMENT_VARS
    cgiGATEWAY_INTERFACE = 20000
    cgiSERVER_NAME
    cgiSERVER_SOFTWARE
    cgiCONTENT_LENGTH
    cgiCONTENT_TYPE
    cgiSCRIPT_NAME
    cgiQUERY_STRING
    cgiREMOTE_HOST
    cgiREMOTE_USER
    cgiSERVER_PROTOCOL
    cgiREQUEST_METHOD
End Enum

'This is an error code returned by a dictionary if we
'attempt to add a key that already exists.
Private Const KEY_EXISTS As Integer = 457

Private Sub Class_Initialize()
    Debug.Print "CCGI Initialize"
    
    'Instatiate the dictionaries and the Standard I/O object
    Set m_dicParams = New Scripting.Dictionary
    Set m_dicEnvVars = New Scripting.Dictionary
    Set m_StdIo = New CStdIO
    
    'Load the CGI evironmental variables into dictionary
    SetEnvirons m_dicEnvVars
    
    'Retrieve the query string and load into dictionary
    SetParams
End Sub

'****************************************************************
'Sets up the parameter dictionary
'****************************************************************
Private Sub SetParams()
    m_sQueryString = GetQueryString()
    ParseQueryString m_sQueryString, m_dicParams
End Sub

'****************************************************************
'Gets the query string from either standard input or the
'QUERY_STRING environmental variable.
'****************************************************************
Private Function GetQueryString() As String
    Dim sResult As String
    Select Case m_dicEnvVars("REQUEST_METHOD")
        Case "GET", "PUT", "HEAD":
            sResult = Environ("QUERY_STRING")
        Case "POST":
            sResult = m_StdIo.ReadIn()
        Case Else
            'Should be one of the above methods
            Debug.Assert False
            Err.Raise cgiINVALID_REQUEST_METHOD Or vbObjectError, _
                        "CCGI.GetQueryString()", _
                        "Invalid Request Method."
    End Select
    GetQueryString = sResult
End Function

'****************************************************************
'Parses the Query String and puts the Name-Value pairs into the
'parameter dictionary.
'****************************************************************
Private Sub ParseQueryString(ByVal sQuery As String, Params As Dictionary)
    Dim arParams() As String
    Dim I As Long
    
    On Error GoTo Handler:
    
    arParams = Split(sQuery, "&")
     
    For I = 0 To UBound(arParams)
        Params.Add GetParamName(arParams(I)), GetParamValue(arParams(I))
    Next I
    
    Exit Sub
    
Handler:
    Dim lErr As Long
    lErr = Err.Number
    Select Case lErr
        Case KEY_EXISTS    'Duplicate key, just skip it
            Resume Next
        Case Else
            Debug.Assert False
            Err.Raise cgiQUERY_STRING_PARSE Or vbObjectError, _
                        "CCGI.ParseQueryString()", _
                        "Could not parse the query string. Check format."
    End Select
End Sub

'****************************************************************
'Returns the Value portion of a Name=Value pair
'****************************************************************
Private Function GetParamValue(ByVal sParam As String) As String
    Dim arPair() As String
    Dim sResult As String
    
    arPair = Split(sParam, "=")
    
    'Replace each + char with a space
    sResult = Replace(arPair(1), "+", " ")
    
    'Convert all %XX hex codes
    GetParamValue = ReplaceHex(sResult)
End Function

'****************************************************************
'Replace the %XX Hex codes with their ASCII equivilant
'****************************************************************
Private Function ReplaceHex(ByVal sValue As String) As String
    Dim I As Integer
    Dim sHex As String
    Dim sResult As String
    
    sResult = sValue
    Do
        I = InStr(I + 1, sResult, "%")
        If (I = 0) Then Exit Do
        sHex = "&H" + Mid(sResult, I + 1, 2)
        sResult = Left(sResult, I - 1) & Chr(CInt(sHex)) _
                    & Mid(sResult, I + 3)
    Loop
    
    ReplaceHex = sResult
        
End Function

'****************************************************************
'Returns the Name portion of a Name=Value pair
'****************************************************************
Private Function GetParamName(ByVal sParam As String) As String
    Dim arPair() As String
    arPair = Split(sParam, "=")
    GetParamName = arPair(0)
End Function

'****************************************************************
'Initialize the environmental variables dictionary
'****************************************************************
Private Sub SetEnvirons(Environs As Dictionary)
    Dim I As Long
    Dim sVar As String
    Dim sValue As String
    For I = cgiGATEWAY_INTERFACE To cgiREQUEST_METHOD
        sVar = LoadResString(I)
        sValue = Environ(sVar)
        If sValue = "" Then sValue = " "
        Debug.Print sVar & " = " & sValue
        Environs.Add sVar, sValue
    Next I
End Sub

'****************************************************************
'Returns the query string
'****************************************************************
Public Property Get QueryString() As String
    QueryString = m_sQueryString
End Property

'****************************************************************
'Returns the parameter dictionary.
'****************************************************************
Public Property Get Params() As Dictionary
    Set Params = m_dicParams
End Property

'****************************************************************
'Returns the environmental variables dictionary
'****************************************************************
Public Property Get Environs() As Dictionary
    Set Environs = m_dicEnvVars
End Property

'****************************************************************
'Returns the Standard input/output object.
'****************************************************************
Public Property Get StdIO() As CStdIO
    Set StdIO = m_StdIo
End Property

Private Sub Class_Terminate()
    Debug.Print "CCGI Terminated"
    
    Set m_dicParams = Nothing
    Set m_dicEnvVars = Nothing
    Set m_StdIo = Nothing
End Sub


